﻿<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.HR" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >

<script runat="server">

    static string wszystkie = "(wszystkie)";

    public class PrnParams : ContextBase {
        public PrnParams(Context context) : base(context) {
            if (context.Contains(typeof(ActualOkres)))
                Okres = ((ActualOkres)context[typeof(ActualOkres)]).Okres;
            else
                Okres = FromTo.Empty;
            UkonczSzkolenia(context);
        }

        string nazwa = wszystkie;
        [Priority(1)]
        [Caption("Nazwa szkolenia")]
        [Dictionary("Kurs.Temat")]
        public string Nazwa {
            get { return nazwa; }
            set {
                nazwa = value;
                if (nazwa != "" && nazwa != wszystkie)
                    podzial = false;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListNazwa() {
            return szkolenia.ToArray();
        }

        bool podzial = false;
        [Priority(2)]
        [Caption("Podział na szkolenia")]
        public bool Podzial {
            get { return podzial; }
            set {
                podzial = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlyPodzial() {
            if (nazwa == "" || nazwa == wszystkie)
                return false;
            return true;
        }

        FromTo okres;
        [Priority(3)]
        [Required]
        [Caption("Za okres")]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value == FromTo.Empty)
                    value = new YearMonth(ActualDate.Today(Context)).ToFromTo();
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public class RowSQL : IComparable {
            string nazwa = string.Empty;
            public string Nazwa {
                get { return nazwa; }
                set { nazwa = value; }
            }
            public int CompareTo(object obj) {
                RowSQL row = obj as RowSQL;
                return Nazwa.CompareTo(row.Nazwa);
            }
        }

        public Query.Table GetTable() {
            Query.Table tUkonczSzkol = new Query.Table("UkonczSzkolenia");
            tUkonczSzkol += new Query.Field("Nazwa");
            return tUkonczSzkol;
        }

        public IEnumerable GetRowsSQL(Context cx) {
            return cx.Session.Execute<RowSQL>(GetTable());
        }

        List<string> szkolenia = new List<string>();

        void UkonczSzkolenia(Context context) {
            szkolenia.Add(wszystkie);
            foreach (RowSQL r in GetRowsSQL(context))
                if (!szkolenia.Contains(r.Nazwa))
                    szkolenia.Add(r.Nazwa);
            szkolenia.Sort();
        }
    }

    PrnParams pars = null;
    [Context(Required = true)]
    public PrnParams Params {
        get { return pars; }
        set { pars = value; }
    }

    class NazwaSzkoleniaComparer : IComparer<UkończoneSzkolenie> {
        public int Compare(UkończoneSzkolenie x, UkończoneSzkolenie y) {
            int cmp = x.Nazwa.CompareTo(y.Nazwa);
            if (cmp == 0)
                cmp = string.Compare(x.Pracownik.NazwiskoImię, y.Pracownik.NazwiskoImię, true);
            return cmp;
        }
    }

    class NazwiskoImieComparer : IComparer<UkończoneSzkolenie> {
        public int Compare(UkończoneSzkolenie x, UkończoneSzkolenie y) {
            return string.Compare(x.Pracownik.NazwiskoImię, y.Pracownik.NazwiskoImię, true);
        }
    }

    protected void dc_ContextLoad(object sender, EventArgs e) {
        List<UkończoneSzkolenie> lista = new List<UkończoneSzkolenie>();
        Row[] rows = (Row[])dc[typeof(Row[])];

        ReportHeader["OKRES"] = pars.Okres.ToString();

        foreach (Pracownik idx in rows)
            foreach (UkończoneSzkolenie us in idx.UkończoneSzkolenia) {
                if (pars.Nazwa != "" && pars.Nazwa != wszystkie)
                    if (us.Nazwa != pars.Nazwa)
                        continue;
                if (!pars.Okres.Contains(us.Okres.To))
                    continue;
                lista.Add(us);
            }

        if (pars.Podzial) {
            colSzkolenie.Visible = false;
            Grid.GroupData0 = colSzkolenie.DataMember;
            Grid.GroupLine = "{0}";
            lista.Sort(new NazwaSzkoleniaComparer());
        } else {
            colSzkolenie.Visible = true;
            lista.Sort(new NazwiskoImieComparer());
        }

        Grid.DataSource = lista;
    }

    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        UkończoneSzkolenie us = (UkończoneSzkolenie)args.Row;

        colWydzial.EditValue = us.Pracownik[us.Okres.To].Etat.Wydzial.Kod;
        colOcena.EditValue = (us.Ocena.Length != 0 ? us.Ocena : "brak");
    }

    public static void Msg(object value) {
    }

</script>

<HTML>
	<HEAD>
		<TITLE>Znajomość języków obcych</TITLE>
		<META content="C#" name="CODE_LANGUAGE">
		<META content="JavaScript" name="vs_defaultClientScript">
		<META content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad" Landscape="True"></ea:DataContext>
			<eb:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" runat="server"
                title="Ukończone szkolenia|Okres: %OKRES%"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" DataMember="DataSource" onbeforerow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." VAlign="Top"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="Pracownik.Nazwisko" Align="Left" Caption="Nazwisko" Width="31" NoWrap="False" VAlign="Top"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="Pracownik.Imie" Align="Left" Caption="Imie" Width="16" NoWrap="False" VAlign="Top"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="Pracownik.Kod" Align="Left" Caption="Kod" Width="12" NoWrap="True" VAlign="Top"></ea:GridColumn>
					<ea:GridColumn runat="server" ID="colWydzial" Align="Left" Caption="Wydział" Width="16" NoWrap="True" VAlign="Top"></ea:GridColumn>
				    <ea:GridColumn runat="server" ID="colSzkolenie" DataMember="Nazwa" Caption="Szkolenia~nazwa" NoWrap="False" Width="31" VAlign="Top"></ea:GridColumn>
				    <ea:GridColumn runat="server" ID="colOkres" DataMember="Okres" Caption="Szkolenia~okres" Width="21" VAlign="Top"></ea:GridColumn>
                    <ea:GridColumn runat="server" ID="colOcena" Caption="Szkolenia~ocena" Width="16" NoWrap="False" VAlign="Top"></ea:GridColumn>
                    <ea:GridColumn runat="server" ID="colUwagi" DataMember="Opis" Caption="Szkolenia~uwagi" NoWrap="False" VAlign="Top"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

